<?php

namespace RtRasel\LaravelInstaller\Helpers;

use Exception;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\Console\Output\BufferedOutput;

class DatabaseManager
{
    /**
     * Migrate and seed the database.
     *
     * @return array
     */
    public function migrateAndSeed()
    {
        $outputLog = new BufferedOutput;

        return $this->migrate($outputLog);
    }

    /**
     * Migrate Only
     *
     * @return array
     */
    public function migrateOnly()
    {
        $outputLog = new BufferedOutput;

        return $this->runMigrate($outputLog);
    }

    /**
     * Run the migration
     *
     * @param  \Symfony\Component\Console\Output\BufferedOutput  $outputLog
     * @return array
     */
    private function runMigrate(BufferedOutput $outputLog)
    {
        try {
            Artisan::call('migrate', ['--force'=> true], $outputLog);
        } catch (Exception $e) {
            return $this->response($e->getMessage(), 'error', $outputLog);
        }

        return $this->response(__('Application has been successfully updated.'), 'success', $outputLog);
    }


    /**
     * Run the migration and call the seeder.
     *
     * @param  \Symfony\Component\Console\Output\BufferedOutput  $outputLog
     * @return array
     */
    private function migrate(BufferedOutput $outputLog)
    {
        try {
            Artisan::call('migrate', ['--force'=> true], $outputLog);
        } catch (Exception $e) {
            return $this->response($e->getMessage(), 'error', $outputLog);
        }

        return $this->seed($outputLog);
    }

    /**
     * Seed the database.
     *
     * @param  \Symfony\Component\Console\Output\BufferedOutput  $outputLog
     * @return array
     */
    private function seed(BufferedOutput $outputLog)
    {
        try {
            Artisan::call('db:seed', ['--force' => true], $outputLog);
        } catch (Exception $e) {
            return $this->response($e->getMessage(), 'error', $outputLog);
        }

        return $this->response(__('Application has been successfully installed.'), 'success', $outputLog);
    }

    /**
     * Return a formatted error messages.
     *
     * @param  string  $message
     * @param  string  $status
     * @param  \Symfony\Component\Console\Output\BufferedOutput  $outputLog
     * @return array
     */
    private function response($message, $status, BufferedOutput $outputLog)
    {
        return [
            'status' => $status,
            'message' => $message,
            'dbOutputLog' => $outputLog->fetch(),
        ];
    }
}
