<?php $__env->startSection('title'); ?>
    <?php echo e(__('My Transactions')); ?> <?php echo e(__('-')); ?> <?php echo e($settings->site_title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="transactions">
  <div class="mx-auto container mx-auto text-center m-4">
    <div class="pxa-4 md:px-0">
      <div class="bg-white border rounded-lg overflow-hidden mx-auto mr-2">
        <div class="text-left px-3 flex items-center justify-between">
          <div class="flex items-center">
            <svg viewBox="0 0 24 24" class="mr-2" style="width: 24px; height: 24px">
              <path fill="currentColor" d="M11 15H17V17H11V15M9 7H7V9H9V7M11 13H17V11H11V13M11 9H17V7H11V9M9 11H7V13H9V11M21 5V19C21 20.1 20.1 21 19 21H5C3.9 21 3 20.1 3 19V5C3 3.9 3.9 3 5 3H19C20.1 3 21 3.9 21 5M19 5H5V19H19V5M9 15H7V17H9V15Z"></path>
            </svg>
            <h2 class="text-lg text-black py-2 font-normal fb"> <?php echo e(__('My Transactions')); ?></h2>
          </div>
        </div>
          <hr>
       <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <!--- item --->
        <div class="transactions-list border-b-2 m-2">
          <div class="sm:flex">
            <div class="w-full sm:w-1/2">
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Date')); ?>: </span> <?php echo e(custom_date($transaction)); ?>

              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Payment Method')); ?>: </span> <?php echo e(strtoupper($transaction->payment_method)); ?>

              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Transaction ID')); ?>: </span> <?php echo e(strtoupper($transaction->transaction_id)); ?>

              </p>

            </div>
            <div class="w-full sm:w-1/2">
    
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Amount')); ?>: </span> 
                <span class="<?php if($transaction->isCredit()): ?> <?php echo e('text-danger'); ?> <?php else: ?> <?php echo e('text-success'); ?> <?php endif; ?>"><?php echo e(price($transaction->amount)); ?></span>
              </p>
              <p class="px-3 py-1 text-left">
                <span class="font-bold"><?php echo e(__('Remarks')); ?>: </span> <?php echo e($transaction->remarks); ?>

              </p>
          </div>
        </div>
        </div>
        <!--- /item ---> 
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> <div class="box-form mx-auto w-36 transactions-not-found">
          <h4 class="fb-normal text-base">No transaction found!</h4>
        </div> 
        <?php endif; ?> 
        <?php if($transactions->lastPage() > 1): ?> 
        <p class="p-3 text-gray-800 text-center border border-b">
          <?php echo e($transactions->links('pagination')); ?>

        </p> 
        <?php endif; ?>
      </div>
    </div>
  </div>
</section> 
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/happytopupbd/public_html/core/resources/views/user/transactions.blade.php ENDPATH**/ ?>